{ config, pkgs, ... }:

{
  # imports = [ ./waybar/default.nix ];

  nixpkgs.config.allowUnfree = true;
  home.packages = with pkgs; [
    atool
    httpie
    font-awesome
    jetbrains-mono
    roboto
    discord
    showmethekey
    eww
    obs-studio
    vlc
    spotify
    nerd-fonts.jetbrains-mono
    catppuccin-cursors.mochaMauve
  ];

  fonts.fontconfig.enable = true;

   home.pointerCursor = {
  name = "mochaMauve";
  package = pkgs.catppuccin-cursors.mochaMauve;
  size = 24;
};




  programs.bash = {
    enable = true;
    shellAliases = {
    nrs = "sudo nixos-rebuild switch";
    };

  };

  programs.lazygit.enable = true;


  



  gtk = {
      enable = true;
      theme = {
        name = "Adwaita-dark";
        package = pkgs.gnome-themes-extra;
      };
    };

  services.ssh-agent.enable = true;

  programs.ssh = {
    enable = true;
    extraConfig = ''
          Host kawcix.pl
      	HostName kawcix.pl
      	User ubuntu
      	IdentityFile ~/.ssh/mojvps

      Host github.com
        HostName github.com
        User git
        IdentityFile ~/.ssh/nazwanwm
        AddKeysToAgent yes
    '';
  };

  programs.vscode = {
    enable = true;
    profiles.default = {
      extensions = with pkgs.vscode-extensions; [
        catppuccin.catppuccin-vsc
      ];

    };
    
  };

   programs.alacritty = {
    enable = true;

    settings = {
      window = {
        opacity = 0.95;
        padding = {
          x = 8;
          y = 6;
        };
      };

      font = {
        normal = {
          family = "JetBrainsMono Nerd Font";
          style = "Regular";
        };
        size = 11.0;
      };

      colors = {
        primary = {
          background = "#1e1e2e";
          foreground = "#cdd6f4";
        };

        cursor = {
          text = "#1e1e2e";
          cursor = "#cdd6f4";
        };

        selection = {
          text = "#1e1e2e";
          background = "#f5e0dc";
        };

        normal = {
          black = "#45475a";
          red = "#f38ba8";
          green = "#a6e3a1";
          yellow = "#f9e2af";
          blue = "#89b4fa";
          magenta = "#f5c2e7";
          cyan = "#94e2d5";
          white = "#bac2de";
        };

        bright = {
          black = "#585b70";
          red = "#f38ba8";
          green = "#a6e3a1";
          yellow = "#f9e2af";
          blue = "#89b4fa";
          magenta = "#f5c2e7";
          cyan = "#94e2d5";
          white = "#a6adc8";
        };

        indexed_colors = [
          { index = 16; color = "#fab387"; }
          { index = 17; color = "#f5e0dc"; }
        ];
      };
    };
  };
  services.hyprpaper = {
    enable = true;
    settings = {
      preload = [ "/etc/nixos/wallpaper3.png" ];
      wallpaper = [ ",/etc/nixos/wallpaper3.png" ];
    };
  };

  home.file.".config/rofi/config.rasi".source = ./rofi/config.rasi;

  home.file.".config/hypr/hyprland.conf".source = ./hyprland/hyprland.conf;

  home.file.".config/eww/eww.scss".source = ./eww/eww.scss;

  home.file.".config/eww/eww.yuck".source = ./eww/eww.yuck;
  home.file.".config/waybar/config.jsonc".source = ./waybar/config.jsonc;
  home.file.".config/waybar/style.css".source = ./waybar/style.css;

  # The state version is required and should stay at the version you
  # originally installed.
  home.stateVersion = "25.05";
}
